/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import satisfyu.beachparty.client.gui.handler.TikiBarGuiHandler;
import satisfyu.beachparty.recipe.TikiBarRecipe;
import satisfyu.beachparty.registry.BlockEntityRegistry;
import satisfyu.beachparty.registry.RecipeRegistry;

public class TikiBarBlockEntity
extends BlockEntity
implements Container,
BlockEntityTicker<TikiBarBlockEntity>,
MenuProvider {
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 3;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int OUTPUT_SLOT = 0;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    protected float experience;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TikiBarBlockEntity.this.fermentationTime;
                case 1 -> TikiBarBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TikiBarBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    TikiBarBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public TikiBarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TIKI_BAR_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    public void dropExperience(ServerLevel world, Vec3 pos) {
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)pos, (int)((int)this.experience));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128448_("FermentationTime");
        this.experience = nbt.m_128457_("Experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128350_("Experience", this.experience);
        nbt.m_128376_("FermentationTime", (short)this.fermentationTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, TikiBarBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
        boolean dirty = false;
        TikiBarRecipe recipeType = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.TIKI_BAR_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        if (this.canCraft(recipeType)) {
            ++this.fermentationTime;
            if (this.fermentationTime == this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipeType);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean canCraft(TikiBarRecipe recipe) {
        if (recipe == null || recipe.m_8043_().m_41619_()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        return this.m_8020_(0).m_41619_() || this.m_8020_(0) == recipe.m_8043_();
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(TikiBarRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            ItemStack output = recipeOutput.m_41777_();
            this.m_6836_(0, output);
        }
        for (Ingredient entry : recipe.m_7527_()) {
            ItemStack remainderStack;
            if (entry.test(this.m_8020_(1))) {
                remainderStack = this.getRemainderItem(this.m_8020_(1));
                this.m_7407_(1, 1);
                if (!remainderStack.m_41619_()) {
                    this.m_6836_(1, remainderStack);
                }
            }
            if (!entry.test(this.m_8020_(2))) continue;
            remainderStack = this.getRemainderItem(this.m_8020_(2));
            this.m_7407_(2, 1);
            if (remainderStack.m_41619_()) continue;
            this.m_6836_(2, remainderStack);
        }
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)stack.m_41720_().m_41469_());
        }
        return ItemStack.f_41583_;
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && stack.m_41656_(stackInSlot) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new TikiBarGuiHandler(syncId, inv, this, this.propertyDelegate);
    }
}

